from passport.backend.qa.autotests.base.builders.base import AutotestsJsonBuilder
from passport.backend.qa.autotests.base.settings.federal_config_api import (
    FEDERAL_CONFIG_TVM_DST_ALIAS,
    FEDERAL_CONFIG_URL,
)


class FederalConfigAPI(AutotestsJsonBuilder):
    def __init__(self):
        super(FederalConfigAPI, self).__init__(
            base_url=FEDERAL_CONFIG_URL,
            tvm_dst_alias=FEDERAL_CONFIG_TVM_DST_ALIAS,
            use_proxy=True,
        )

    def request(self, method, path, form_params=None, query_params=None, headers=None,
                expected_http_status=200, **kwargs):
        query_params = query_params or {}
        return super(FederalConfigAPI, self).request(
            method=method,
            path=path,
            form_params=form_params,
            query_params=query_params,
            headers=headers,
            expected_http_status=expected_http_status,
            **kwargs,
        )
