from passport.backend.qa.autotests.base.builders.base import AutotestsJsonBuilder
from passport.backend.qa.autotests.base.settings.oauth import (
    OAUTH_CONSUMER,
    OAUTH_TVM_DST_ALIAS,
    OAUTH_URL,
)


class OAuth(AutotestsJsonBuilder):
    def __init__(self):
        super(OAuth, self).__init__(
            base_url=OAUTH_URL,
            tvm_dst_alias=OAUTH_TVM_DST_ALIAS,
            use_proxy=True,
        )

    def request(self, method, path, form_params=None, query_params=None, headers=None,
                expected_http_status=200, **kwargs):
        query_params = query_params or {}
        query_params['consumer'] = OAUTH_CONSUMER
        return super(OAuth, self).request(
            method=method,
            path=path,
            form_params=form_params,
            query_params=query_params,
            headers=headers,
            expected_http_status=expected_http_status,
            **kwargs,
        )
