from passport.backend.qa.autotests.base.builders.base import (
    AutotestsBuilderTemporaryError,
    AutotestsBuilderUnexpectedResponseError,
    AutotestsJsonBuilder,
)
from passport.backend.qa.autotests.base.settings.passport_api import (
    PASSPORT_API_TVM_DST_ALIAS,
    PASSPORT_API_URL,
    PASSPORT_API_USE_PROXY,
    PASSPORT_CONSUMER,
)


class PassportApi(AutotestsJsonBuilder):
    def __init__(self):
        super(PassportApi, self).__init__(
            base_url=PASSPORT_API_URL,
            tvm_dst_alias=PASSPORT_API_TVM_DST_ALIAS,
            use_proxy=PASSPORT_API_USE_PROXY,
        )

    def error_detector(self, response, raw_response):
        errors = response.get('errors', [])
        if 'exception.unhandled' in errors:
            raise AutotestsBuilderUnexpectedResponseError(errors)
        elif any(
            error.startswith('backend.') and error.endswith('_failed')
            for error in errors
        ):
            raise AutotestsBuilderTemporaryError(errors)

    def request(self, method, path, form_params=None, query_params=None, headers=None,
                expected_http_status=200, **kwargs):
        query_params = query_params or {}
        query_params['consumer'] = PASSPORT_CONSUMER

        return super(PassportApi, self).request(
            method=method,
            path=path,
            form_params=form_params,
            query_params=query_params,
            headers=headers,
            expected_http_status=expected_http_status,
            **kwargs,
        )
