from passport.backend.qa.autotests.base.builders.base import AutotestsJsonBuilder
from passport.backend.qa.autotests.base.settings.social import (
    SOCIAL_API_TVM_DST_ALIAS,
    SOCIAL_BROKER_TVM_DST_ALIAS,
    SOCIAL_CONSUMER,
    SOCIAL_URL,
)


class SocialRequestMixin(object):
    def request(
        self,
        method,
        path,
        query_params=None,
        form_params=None,
        **kwargs
    ):
        query_params = dict(query_params) if query_params else dict()
        query_params['consumer'] = SOCIAL_CONSUMER
        return super(SocialRequestMixin, self).request(
            method=method,
            path=path,
            form_params=form_params,
            query_params=query_params,
            **kwargs,
        )


class SocialApi(
    SocialRequestMixin,
    AutotestsJsonBuilder,
):
    def __init__(self):
        super(SocialApi, self).__init__(
            base_url=SOCIAL_URL,
            tvm_dst_alias=SOCIAL_API_TVM_DST_ALIAS,
            use_proxy=True,
        )


class SocialBroker(
    SocialRequestMixin,
    AutotestsJsonBuilder,
):
    def __init__(self):
        super(SocialBroker, self).__init__(
            base_url=SOCIAL_URL,
            tvm_dst_alias=SOCIAL_BROKER_TVM_DST_ALIAS,
            use_proxy=True,
        )
