from hamcrest import (
    assert_that,
    has_key,
)
from passport.backend.qa.autotests.base.builders.proxied.passport_api import PassportApi
from passport.backend.qa.autotests.base.helpers.common import build_api_basic_headers
from passport.backend.qa.autotests.base.settings.common import PASSPORT_HOST
from passport.backend.qa.autotests.base.steps.cookie_steps import (
    dump_cookies_to_header,
    parse_cookies,
)


def get_cookies_by_token(token):
    rv = PassportApi().post(
        '/1/bundle/auth/token/',
        form_params=dict(
            type='x-token',
            retpath='https://{}/test'.format(PASSPORT_HOST),
        ),
        headers=build_api_basic_headers(token=token),
    )
    assert_that(rv, has_key('track_id'), 'response: {}'.format(rv))
    track_id = rv['track_id']

    rv = PassportApi().post(
        '/1/bundle/session/',
        form_params=dict(track_id=track_id),
        headers=build_api_basic_headers(token=token, cookie=''),
    )
    assert_that(
        rv,
        has_key('cookies'),
    )
    cookies = parse_cookies(rv['cookies'])
    return dump_cookies_to_header(cookies)
