from hamcrest import (
    anything,
    assert_that,
    has_entries,
    has_entry,
    has_item,
    has_key,
    is_not,
)
from passport.backend.core.eav_type_mapping import (
    alias_name_exists,
    ALIAS_NAME_TO_TYPE,
    get_attr_type,
)
from passport.backend.core.serializers.eav.base.base import EavSerializer
from passport.backend.qa.autotests.base.steps.blackbox import userinfo_by_uid


def check_blackbox_userinfo_by_uid(uid, attributes_values=None, aliases=None, phone=None):
    rv = userinfo_by_uid(
        uid,
        attributes=list(attributes_values.keys()) if attributes_values else None,
        aliases='all_with_hidden' if aliases else None,
        getphones='bound' if phone else None,
        phone_attributes=EavSerializer.ext_attr_name_to_type('phone', 'number') if phone else None,
    )

    assert_that(rv, has_key('users'))
    assert len(rv['users']) == 1
    user = rv['users'][0]

    if attributes_values:
        assert_that(user, has_key('attributes'))

        for attr, value in attributes_values.items():
            attr_type = get_attr_type(attr)
            if value is not None:
                assert_that(
                    user['attributes'],
                    has_entry(
                        str(attr_type),
                        value,
                    ),
                    'attribute {} value'.format(attr),
                )
            else:
                assert_that(
                    user['attributes'],
                    is_not(has_key(str(attr_type))),
                    'attribute {} must be missing'.format(attr),
                )

    if aliases:
        assert_that(user, has_key('aliases'))

        for attr, value in aliases.items():
            if not str(attr).isdigit() and alias_name_exists(attr):
                attr = ALIAS_NAME_TO_TYPE(attr)
            else:
                continue

            if value is not None:
                assert_that(
                    user['aliases'],
                    has_entry(
                        str(attr),
                        value,
                    ),
                    'alias {} value'.format(attr),
                )
            else:
                assert_that(
                    user['aliases'],
                    is_not(has_key(str(attr))),
                    'alias {} must be missing'.format(attr),
                )

    if phone:
        assert_that(user, has_key('phones'))

        assert_that(
            user,
            has_entries(
                phones=has_item(
                    has_entries(
                        attributes=has_entries(**{
                            str(EavSerializer.ext_attr_name_to_type('phone', 'number')): phone,
                        }),
                        id=anything(),
                    ),
                ),
            ),
            'res={}'.format(rv),
        )
