import re
import time

from passport.backend.qa.autotests.base.settings.common import PASSPORT_HOST
from passport.backend.qa.autotests.base.test_env import test_env


def universal_decorator(outer):
    """
    Такой декоратор может быть вызван как
    decorator
    или
    decorator(some_args...)

    Все аргументы декоратора должны иметь значения по умолчанию
    """
    def inner(*args, **kwargs):
        if len(args) == 1 and not kwargs and callable(args[0]):
            return outer()(args[0])
        else:
            return outer(*args, **kwargs)

    return inner


def build_api_basic_headers(cookie=None, token=None):
    headers = {
        'Ya-Client-Host': PASSPORT_HOST,
        'Ya-Client-User-Agent': test_env.user_agent,
        'Ya-Consumer-Client-Ip': test_env.user_ip,
    }
    if cookie is not None:
        headers['Ya-Client-Cookie'] = cookie,
    if token:
        headers['Ya-Consumer-Authorization'] = 'OAuth ' + token

    return headers


def retry_codeblock(callback, retries=5, wait=0.5, expected_regex=None, expected_substr=None):
    n_tries = 0
    while True:
        try:
            callback()
            break
        except AssertionError as err:
            message = str(err)
            if expected_regex and not re.search(expected_regex, message):
                raise AssertionError('(retry: wrong pattern) {}'.format(message))
            if expected_substr and expected_substr.lower() not in message.lower():
                raise AssertionError('(retry: wrong text) {}'.format(message))
            n_tries += 1
            if n_tries == retries:
                raise AssertionError('(after {} tries) {}'.format(retries, message))
            time.sleep(wait)
