from http.cookies import SimpleCookie


def parse_cookies(raw_cookies) -> SimpleCookie:
    if isinstance(raw_cookies, (list, tuple)):
        raw_cookies = '; '.join(raw_cookies)

    cookies = SimpleCookie()
    cookies.load(raw_cookies)
    return cookies


def dump_cookies_to_header(cookies: SimpleCookie) -> str:
    return cookies.output(attrs='', header='', sep=';').strip()


def add_cookies_to_header(header: str, name: str, value: str):
    cookies = SimpleCookie()
    cookies.load(header)
    cookies[name] = value
    return cookies.output(attrs='', header='', sep=';').strip()
