from hamcrest import (
    all_of,
    assert_that,
    equal_to,
)
from passport.backend.qa.autotests.base.helpers.common import build_api_basic_headers
from passport.backend.qa.autotests.base.matchers.token import (
    token_is_trusted,
    token_is_valid,
    verify_token,
)
from passport.backend.qa.autotests.base.secrets import secrets
from passport.backend.qa.autotests.base.steps.challenge import PassAuthChallengeStep
from passport.backend.qa.autotests.base.steps.phone import bind_secure_phone
from passport.backend.qa.autotests.base.steps.token_steps import issue_token_by_sessionid
from passport.backend.qa.autotests.base.steps.tracks import set_track_state
from passport.backend.utils.phones import random_phone_number


def pass_sms_challenge(account, track_id):
    set_track_state(track_id, is_auth_challenge_shown=True, antifraud_tags=['sms'])
    bind_secure_phone(account, random_phone_number())
    helper = PassAuthChallengeStep().with_account(account).with_track(track_id)
    helper.challenge_submit()
    assert_that(helper.default_challenge, equal_to('phone_confirmation'))
    helper.challenge_commit()


def make_trusted_xtoken(account, track_id, with_assertion=True, device_info=None):
    pass_sms_challenge(account, track_id)
    token = issue_token_by_sessionid(
        headers=build_api_basic_headers(cookie=account.cookies),
        client_id=secrets.OAUTH_XTOKEN_CLIENT_ID,
        client_secret=secrets.OAUTH_XTOKEN_CLIENT_SECRET,
        track_id=track_id,
        device_info=device_info or {},
    )
    if with_assertion:
        assert_that(
            verify_token(token, get_is_xtoken_trusted='yes'),
            all_of(
                token_is_valid(),
                token_is_trusted(),
            ),
        )
    return token
