from hamcrest.core.base_matcher import BaseMatcher
from passport.backend.utils.phones import compare_phone_numbers


class _EqualsToPhoneNumber(BaseMatcher):
    def __init__(self, phone_number: str, add_plus_if_needed=False):
        self.add_plus_if_needed = add_plus_if_needed
        self.phone_number = phone_number

    def _preprocess(self, phone_number: str):
        if self.add_plus_if_needed and not phone_number.startswith('+'):
            return '+' + phone_number
        else:
            return phone_number

    def _matches(self, phone_number: str):
        return compare_phone_numbers(
            self._preprocess(phone_number),
            self._preprocess(self.phone_number),
        )

    def describe_to(self, description):
        description.append_text('не является номером телефона {}'.format(self.phone_number))

    def describe_mismatch(self, bb_response, mismatch_description):
        mismatch_description.append_text('is phone_number({})'.format(self.phone_number))


def equals_to_phone_number(phone_number: str, add_plus_if_needed=False):
    return _EqualsToPhoneNumber(phone_number, add_plus_if_needed=add_plus_if_needed)
