# -*- coding: utf-8 -*-
import os


class SecretsManager:
    def __getitem__(self, key):
        variable_name = f'PASSPORT_AUTOTESTS_{key.upper()}'
        if variable_name not in os.environ:
            raise KeyError(f'Secret `{key}` not found: environment variable `{variable_name}` not set')
        return os.environ[variable_name]

    def __getattr__(self, key):
        if key.startswith('__'):
            return super(SecretsManager, self).__getattr__(key)
        return self[key]


secrets = SecretsManager()
