import os

from passport.backend.qa.autotests.base.secrets.secrets_manager import secrets
from passport.backend.qa.autotests.base.settings.tvm import TVM_DSTS
import tvmauth


class TvmAuthCredentialManager:
    def __init__(self):
        self.tvm_client = tvmauth.TvmClient(
            tvmauth.TvmApiClientSettings(
                self_tvm_id=int(secrets.SELF_TVM_CLIENT_ID),
                self_secret=secrets.SELF_TVM_CLIENT_SECRET,
                dsts=TVM_DSTS,
                disk_cache_dir='/tmp/passport/autotests/%s/tvm_cache/' % os.environ.get('USER', 'default'),
            )
        )

    def get_ticket_by_alias(self, dst_alias):
        return self.tvm_client.get_service_ticket_for(dst_alias)


_tvm_client = None


def get_tvm_client():
    global _tvm_client
    if not _tvm_client:
        _tvm_client = TvmAuthCredentialManager()
    return _tvm_client
