from passport.backend.qa.autotests.base.settings.env import (
    ENV,
    update_with_env,
)


_PASSPORT_HOSTS = {
    'development': 'autotests.dev.passport.yandex.ru',
    'testing': 'passport-test.yandex.ru',
    'rc': 'passport-rc.yandex.ru',
    'production': 'passport.yandex.ru',
    'intranet_testing': 'passport-test.yandex-team.ru',
    'intranet_rc': 'passport-rc.yandex-team.ru',
    'intranet_production': 'passport.yandex-team.ru',
}
PASSPORT_HOST = _PASSPORT_HOSTS[ENV]


_PASSPORT_URL_TEMPLATES = {
    'development': 'https://0.passportdev.yandex.%(tld)s',
    'testing': 'https://passport-test.yandex.%(tld)s',
    'rc': 'https://passport-rc.yandex.%(tld)s',
    'production': 'https://passport.yandex.%(tld)s',
    'intranet_testing': 'https://passport-test.yandex-team.%(tld)s',
    'intranet_rc': 'https://passport-rc.yandex-team.%(tld)s',
    'intranet_production': 'https://passport.yandex-team.%(tld)s',
}
PASSPORT_URL_TEMPLATE = _PASSPORT_URL_TEMPLATES[ENV]


DEFAULT_USER_AGENT = 'passport-autotests-useragent'

DEFAULT_FLAKY_TEST_RETRIES = 3


update_with_env(globals())
