# -*- coding: utf-8 -*-
import os
from typing import Any


ENV = os.environ.get('ENV', 'testing')


def update_with_env(namespace: dict[str, Any]):
    for k, v in namespace.items():
        if k.isupper():
            namespace[k] = os.environ.get('YTEST_{}'.format(k), v)


update_with_env(globals())
