import allure
from hamcrest import (
    assert_that,
    has_entries,
)
from passport.backend.qa.autotests.base.account import Account
from passport.backend.qa.autotests.base.builders.proxied.passport_api import PassportApi
from passport.backend.qa.autotests.base.settings.common import PASSPORT_HOST
from passport.backend.qa.autotests.base.steps.ticket_steps import get_userticket
from passport.backend.qa.autotests.base.test_env import test_env
from passport.backend.utils.common import noneless_dict


def _get_headers():
    return {
        'Ya-Client-Host': PASSPORT_HOST,
        'Ya-Client-User-Agent': test_env.user_agent,
        'Ya-Consumer-Client-Ip': test_env.user_ip,
    }


@allure.step('Добавляем аккаунту КВ\\КО')
def add_question(
    uid,
    question='question',
    question_id=None,
    answer='answer',
    display_language='ru',
):

    additional_args = noneless_dict(
        question=question,
        question_id=question_id,
        answer=answer,
        display_language=display_language,
    )
    rv = PassportApi().post(
        path='/1/account/questions/',
        form_params={
            'uid': uid,
            **additional_args
        },
        headers=_get_headers(),
    )
    assert_that(
        rv,
        has_entries(
            status='ok',
        ),
    )


@allure.step('Установка Options на аккаунт')
def set_options(
    user,
    **kwargs
):
    user_ticket = get_userticket(user)

    rv = PassportApi().post(
        path='/2/account/options/',
        form_params={
            **kwargs
        },
        headers={
            'X-Ya-User-Ticket': user_ticket,
            **_get_headers()
        },
    )
    assert_that(
        rv,
        has_entries(
            status='ok',
        ),
        'rv={}'.format(rv),
    )


@allure.step('Установка password options на аккаунт')
def set_password_options(
    user: Account,
    user_ticket=None,
    **kwargs
):
    user_ticket = user_ticket or get_userticket(user)

    rv = PassportApi().post(
        path='/2/account/{}/password_options/'.format(user.uid),
        form_params={
            **kwargs
        },
        headers={
            'X-Ya-User-Ticket': user_ticket,
            **_get_headers()
        },
    )
    assert_that(
        rv,
        has_entries(
            status='ok',
        ),
        'rv={}'.format(rv),
    )


@allure.step('Установить алиас на аккаунт')
def set_alias(
    user: Account,
    alias_type,
    **kwargs
):
    rv = PassportApi().post(
        path='/1/account/%s/alias/%s/' %(user.uid, alias_type),
        form_params={
            **kwargs,
        },
        headers=_get_headers(),
    )

    assert_that(
        rv,
        has_entries(
            status='ok',
        ),
    )
