import allure
from hamcrest import (
    assert_that,
    has_key,
)
from passport.backend.qa.autotests.base.account import Account
from passport.backend.qa.autotests.base.builders.proxied.passport_api import PassportApi
from passport.backend.qa.autotests.base.helpers.cookies import (
    dump_cookies_to_header,
    parse_cookies,
)
from passport.backend.qa.autotests.base.settings.common import PASSPORT_HOST
from passport.backend.qa.autotests.base.steps.challenge import PassAuthChallengeStep
from passport.backend.qa.autotests.base.test_env import test_env


@allure.step('Получение авторизационных кук')
def get_cookies(user: Account, dump=True, allow_challenge=False):
    assert user.login and user.password, 'Для получения кук этим методом требуется аккаунт с логином и паролем'
    # TODO: @retry_if()
    rv = PassportApi().post(
        path='/1/bundle/auth/password/submit/',
        form_params={
            'login': user.login,
            'password': user.password,
        },
        headers={
            'Ya-Client-Host': PASSPORT_HOST,
            'Ya-Client-User-Agent': test_env.user_agent,
            'Ya-Client-Cookie': '',
            'Ya-Consumer-Client-Ip': test_env.user_ip,
        },
    )
    if rv.get('state') == 'auth_challenge':
        if allow_challenge:
            assert_that(rv, has_key('track_id'))
            track_id = rv['track_id']
            helper = PassAuthChallengeStep().with_account(user).with_track(track_id)
            helper.challenge_submit()
            helper.challenge_commit()
            return get_cookies_by_track(track_id=track_id, dump=dump)
        else:
            raise RuntimeError('Challenge is required: {}'.format(rv))
    assert_that(
        rv,
        has_key('cookies'),
    )
    cookies = parse_cookies(rv['cookies'])
    return dump_cookies_to_header(cookies) if dump else cookies


@allure.step('Получение авторизационных кук по треку')
def get_cookies_by_track(track_id, dump=True):
    rv = PassportApi().post(
        path='/1/bundle/session/',
        form_params={
            'track_id': track_id,
        },
        headers={
            'Ya-Client-Host': PASSPORT_HOST,
            'Ya-Client-User-Agent': test_env.user_agent,
            'Ya-Client-Cookie': '',
            'Ya-Consumer-Client-Ip': test_env.user_ip,
        },
    )
    assert_that(
        rv,
        has_key('cookies'),
    )
    cookies = parse_cookies(rv['cookies'])
    return dump_cookies_to_header(cookies) if dump else cookies
