import allure
from hamcrest import (
    assert_that,
    has_entries,
)
from passport.backend.qa.autotests.base.builders.proxied.passport_api import PassportApi
from passport.backend.qa.autotests.base.settings.common import PASSPORT_HOST
from passport.backend.qa.autotests.base.test_env import test_env


def _get_headers():
    return {
        'Ya-Client-Host': PASSPORT_HOST,
        'Ya-Client-User-Agent': test_env.user_agent,
        'Ya-Consumer-Client-Ip': test_env.user_ip,
    }


@allure.step('Отправляем код подтверждения владения email')
def confirm_email_ownership_send_code(track_id, check_result=True):
    rv = PassportApi().post(
        path='/1/bundle/email/check_ownership/send_code/',
        form_params={
            'track_id': track_id,
        },
        headers=_get_headers(),
    )
    if check_result:
        assert_that(
            rv,
            has_entries(
                status='ok',
            ),
        )

    return rv


@allure.step('Проверяем код подтверждения владения email')
def confirm_email_ownership_with_code(track_id, uid, code, check_result=True):
    rv = PassportApi().post(
        path='/1/bundle/email/check_ownership/confirm/',
        form_params={
            'track_id': track_id,
            'uid': uid,
            'code': code,
        },
        headers=_get_headers(),
    )
    if check_result:
        assert_that(
            rv,
            has_entries(
                status='ok',
            ),
        )

    return rv
