import allure
from hamcrest import (
    anything,
    assert_that,
    has_entries,
)
from passport.backend.qa.autotests.base.builders.proxied.passport_api import PassportApi
from passport.backend.qa.autotests.base.settings.common import PASSPORT_HOST
from passport.backend.qa.autotests.base.steps.push_api_steps import PushApiStep
from passport.backend.qa.autotests.base.steps.tracks import read_track
from passport.backend.qa.autotests.base.test_env import test_env


class Push2faStep(PushApiStep):
    def __init__(self):
        super().__init__()
        self.track_id = None

    def _make_headers(self, cookies=None):
        return {
            'Ya-Client-Host': PASSPORT_HOST,
            'Ya-Client-User-Agent': test_env.user_agent,
            'Ya-Client-Cookie': cookies or '',
            'Ya-Consumer-Client-Ip': test_env.user_ip,
        }

    def with_track(self, track_id):
        self.track_id = track_id
        return self

    @allure.step('Отправка 2fa пуша')
    def send_push(self, check_response=True):
        rv = PassportApi().post(
            headers=self._make_headers(),
            form_params=dict(
                track_id=self.track_id,
            ),
            path='/1/bundle/push/2fa/send/',
        )
        if check_response:
            assert_that(
                rv,
                has_entries(status='ok'),
            )

        return rv

    @allure.step('Получение кода из 2fa пуша')
    def get_code(self, check_response=True):
        rv = PassportApi().get(
            headers=self._make_headers(cookies=self.account.cookies),
            query_params=dict(
                track_id=self.track_id,
            ),
            path='/1/bundle/push/2fa/get_code/',
        )
        if check_response:
            assert_that(
                rv,
                has_entries(
                    status='ok',
                    otp=anything(),
                ),
            )

        return rv

    @allure.step('Получение пуш otp из трека')
    def get_code_from_track(self):
        track = read_track(self.track_id)
        return track.get('push_otp')
