import allure
from passport.backend.qa.autotests.base.account import Account
from passport.backend.qa.autotests.base.builders.proxied.blackbox import Blackbox
from passport.backend.qa.autotests.base.secrets import secrets
from passport.backend.qa.autotests.base.test_env import test_env

from .token_steps import issue_token


@allure.step('Получение User-ticket\'а')
def get_userticket(user: Account, **kwargs):
    token = issue_token(
        user=user,
        client_id=secrets.OAUTH_XTOKEN_CLIENT_ID,
        client_secret=secrets.OAUTH_XTOKEN_CLIENT_SECRET,
    )

    return Blackbox().get(
        path='/blackbox',
        query_params=dict(
            method='oauth',
            userip=test_env.user_ip,
            format='json',
            get_user_ticket=True,
            oauth_token=token,
            **kwargs
        ),
    )['user_ticket']
