import allure
from hamcrest import (
    assert_that,
    has_key,
)
from passport.backend.qa.autotests.base.account import Account
from passport.backend.qa.autotests.base.builders.proxied.oauth import OAuth
from passport.backend.qa.autotests.base.builders.proxied.passport_api import PassportApi


@allure.step('Получение токена')
def issue_token(user: Account, client_id: str, client_secret: str, **kwargs) -> str:
    assert user.login and user.password, 'Для получения токена этим методом требуется аккаунт с логином и паролем'

    rv = OAuth().post(
        path='/token',
        form_params={
            'grant_type': 'password',
            'client_id': client_id,
            'client_secret': client_secret,
            'username': user.login,
            'password': user.password,
            **kwargs,
        },
    )
    assert_that(
        rv,
        has_key('access_token'),
    )
    return rv['access_token']


@allure.step('Получение токена через api-прокси')
def issue_token_by_sessionid(headers, client_id, client_secret, device_info=None, **kwargs) -> str:
    rv = PassportApi().post(
        path='/1/bundle/oauth/token_by_sessionid/',
        headers=headers,
        form_params={
            'client_id': client_id,
            'client_secret': client_secret,
            **kwargs,
        },
        query_params=device_info or {},
    )
    assert_that(
        rv,
        has_key('access_token'),
    )
    return rv['access_token']
