OWNER(g:passport_python)

PY3_LIBRARY()

PEERDIR(
    contrib/python/flaky
    library/python/pytest/allure

    passport/backend/contrib/nose_parameterized
    passport/backend/core/builders/frodo
    passport/backend/core/crypto
    passport/backend/core/serializers/eav/base
    passport/backend/qa/autotests/base/builders
    passport/backend/qa/autotests/base/matchers
    passport/backend/qa/autotests/base/secrets
    passport/backend/qa/autotests/base/settings

    passport/backend/utils
    passport/backend/utils/phones
)

PY_SRCS(
    helpers/__init__.py
    helpers/account.py
    helpers/account_manager.py
    helpers/blackbox.py
    helpers/cookies.py
    helpers/common.py
    helpers/push_challenge.py
    steps/__init__.py
    steps/account.py
    steps/auth.py
    steps/blackbox.py
    steps/challenge.py
    steps/cookie_steps.py
    steps/domain_steps.py
    steps/email_steps.py
    steps/otp.py
    steps/phone.py
    steps/push_2fa_steps.py
    steps/push_api_steps.py
    steps/registration_steps.py
    steps/ticket_steps.py
    steps/token_steps.py
    steps/tracks.py
    __init__.py
    account.py
    accounts_store.py
    allure.py
    domain.py
    test_env.py
    testcase.py
)

END()

RECURSE(
    builders
    matchers
    secrets
    settings
)
