# -*- coding: utf-8 -*-
import base64

import allure
from passport.backend.qa.autotests.base.secrets import secrets
from passport.backend.qa.autotests.base.testcase import BaseTestCase
from passport.backend.utils.string import smart_bytes


class BaseIssueTokenTestCase(BaseTestCase):
    @allure.step
    def setUp(self):
        super(BaseIssueTokenTestCase, self).setUp()
        self.client_id = secrets.OAUTH_YA_LOGIN_CLIENT_ID

    @staticmethod
    def make_auth_headers(client_id=None, client_secret=None):
        client_id = client_id or secrets.OAUTH_YA_LOGIN_CLIENT_ID
        client_secret = client_secret or secrets.OAUTH_YA_LOGIN_CLIENT_SECRET
        encoded_creds = base64.b64encode(
            smart_bytes('{}:{}'.format(client_id, client_secret)),
        ).decode()
        return {
            'Authorization': f'Basic {encoded_creds}',
        }
