import allure
from passport.backend.qa.autotests.base.builders.proxied.blackbox import Blackbox
from passport.backend.qa.autotests.base.test_env import test_env
from passport.backend.qa.autotests.base.testcase import (
    BaseTestCase,
    limit_envs,
)


@limit_envs(
    description='Для ятима пока нет тестовых аккаунтов',
    intranet_production=False,
    intranet_testing=False,
)
class BaseScholarTestCase(BaseTestCase):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.account = None
        self.cookies = None

    @allure.step('Получение данных о школьнике из ЧЯ')
    def get_scholar_userinfo_from_blackbox(self):
        return Blackbox().get(
            path='/blackbox',
            query_params=dict(
                aliases='all',
                attributes=[
                    'account.global_logout_datetime',
                    'account.scholar_password',
                    'person.firstname',
                    'person.lastname',
                ],
                format='json',
                method='userinfo',
                uid=str(self.account.uid),
                userip=test_env.user_ip,
            ),
        )
