PY3_LIBRARY()

NEED_REVIEW()

OWNER(
    gladnik
)

PEERDIR(
    contrib/python/Flask
    contrib/python/Werkzeug
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/gunicorn
    contrib/python/psycopg2
    contrib/python/requests
    contrib/python/gevent

    library/python/monlib

    passport/backend/contrib/formencode
    passport/backend/core/builders/kolmogor
    passport/backend/core/conf
    passport/backend/core/logging_utils
    passport/backend/core/utils/decorators
    passport/backend/utils
)

PY_SRCS(
    __init__.py
    app.py
    backend.py
    common/__init__.py
    common/blackbox/__init__.py
    common/blackbox/blackbox.py
    common/idm/__init__.py
    common/idm/idm_public_api.py
    common/idm/idm_settings.py
    common/kolmogor/__init__.py
    common/kolmogor/kolmogor_utils.py
    common/passport/__init__.py
    common/passport/passport_api.py
    common/xunistater/__init__.py
    common/xunistater/xunistater.py
    db.py
    db_schema.py
    db_session.py
    exceptions.py
    fillers.py
    idm_backend.py
    logger.py
    models/__init__.py
    models/account.py
    request_id.py
    settings.py
    tvm.py
    utils.py
    validators/__init__.py
    validators/base_login_validator.py
    validators/delete_after_validator.py
    validators/env_validator.py
    validators/idm_role.py
    validators/login.py
    validators/phone.py
    validators/tags.py
    validators/tus_consumer.py
    validators/weak_login_validator.py
    validators/weak_uid_validator.py
    views/__init__.py
    views/base.py
    views/headers.py
    views/tus/__init__.py
    views/tus/bind_phone.py
    views/tus/create_account/__init__.py
    views/tus/create_account/portal.py
    views/tus/create_consumer.py
    views/tus/get_account.py
    views/tus/list_accounts.py
    views/tus/ping.py
    views/tus/remove_account.py
    views/tus/save_account.py
    views/tus/tus_base.py
    views/tus/unlock_account.py
    views/idm/__init__.py
    views/idm/idm_base.py
    views/idm/info.py
    views/idm/add_role.py
    views/idm/remove_role.py
    views/idm/get_all_roles.py
)

END()

RECURSE(bin)

RECURSE_FOR_TESTS(
    tests
)
