package internal

import (
	"encoding/json"
	"io/ioutil"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type Config struct {
	SelfTvmID          tvm.ClientID   `json:"self_tvm_id"`
	AllowedTvmIDs      []tvm.ClientID `json:"allowed_tvm_id"`
	AllowedTargetHosts []string       `json:"allowed_target_hosts"`
}

func ReadConfig(configFileName string, logger log.Logger) *Config {
	configFile, err := ioutil.ReadFile(configFileName)
	if err != nil {
		logger.Fatalf("Failed to open configuration file %s", configFileName)
		panic(err)
	}
	proxyConfig := Config{}
	err = json.Unmarshal(configFile, &proxyConfig)
	if err != nil {
		logger.Fatalf("Failed to parse config from file %s", configFileName)
		panic(err)
	}
	return &proxyConfig
}
