package internal

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/nop"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmauth"
)

type TVM struct {
	client     *tvmauth.Client
	allowedIDs map[tvm.ClientID]interface{}
}

func InitTVM(proxyCfg *Config, logger log.Logger) *TVM {
	var tvmAgent TVM
	logger.Debug("Initializing TVM")
	tvmAgent.allowedIDs = map[tvm.ClientID]interface{}{}
	for _, allowedID := range proxyCfg.AllowedTvmIDs {
		tvmAgent.allowedIDs[allowedID] = true
	}
	settings := tvmauth.TvmAPISettings{
		SelfID:                      proxyCfg.SelfTvmID,
		EnableServiceTicketChecking: true,
		DiskCacheDir:                "/var/tmp/cache/tvm/",
	}

	var err error
	tvmAgent.client, err = tvmauth.NewAPIClient(settings, &nop.Logger{})
	if err != nil {
		logger.Fatalf("Failed to init TVM with error: %+v", err)
		panic(err)
	}
	logger.Debug("Completed TVM initialization")
	return &tvmAgent
}
