package crud

import (
	"fmt"
	"reflect"

	"github.com/elimity-com/scim"

	"a.yandex-team.ru/passport/backend/scim_api/internal/core/models"
)

var tagName = "patch"

func patchAttrName(patch scim.PatchOperation) string {
	if patch.Path.AttributePath.SubAttribute == nil {
		return patch.Path.AttributePath.AttributeName
	} else {
		return patch.Path.AttributePath.AttributeName + "." + *patch.Path.AttributePath.SubAttribute
	}
}

func applySinglePatch(user *models.User, patch scim.PatchOperation) bool {
	v := reflect.ValueOf(user).Elem()
	t := reflect.TypeOf(*user)
	for i := 0; i < v.NumField(); i++ {
		field := t.Field(i)
		tagValue := field.Tag.Get(tagName)
		if tagValue == patchAttrName(patch) {
			// FIXME надо поддержать работу еще с add / delete
			// FIXME и поддержать работу с комплексными типами (списки с диктами)
			if patch.Op == scim.PatchOperationReplace {
				f := v.FieldByName(field.Name)
				if !f.CanSet() {
					panic(fmt.Errorf("field setability is false"))
				}
				switch patch.Value.(type) {
				case string:
					f.SetString(patch.Value.(string))
					return true
				case bool:
					f.SetBool(patch.Value.(bool))
					return true
				default:
					panic(fmt.Errorf("type unknown"))
				}
			}
		}
	}
	return false
}

func applyPatches(user *models.User, patches []scim.PatchOperation) bool {
	var madeChanges bool
	for _, p := range patches {
		madeChanges = applySinglePatch(user, p) || madeChanges
	}
	return madeChanges
}
