package fedcfg

import (
	"context"
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/passport/backend/scim_api/internal/core/interfaces"
	"a.yandex-team.ru/passport/backend/scim_api/internal/core/models"
	"a.yandex-team.ru/passport/backend/scim_api/internal/fedcfgclient"
	"a.yandex-team.ru/passport/backend/scim_api/internal/logutils"
)

type fedCfgAdapter struct {
	client fedcfgclient.APIClient
	logger log.Logger
}

func (a *fedCfgAdapter) logCtx(ctx context.Context) log.Logger {
	return logutils.AddCommonFromContext(ctx, a.logger)
}

// compile-time проверка, что интерфейс имплементирован корректно
var _ interfaces.FederationConfigAdapter = (*fedCfgAdapter)(nil)

func New(client fedcfgclient.APIClient, logger log.Logger) *fedCfgAdapter {
	return &fedCfgAdapter{
		client: client,
		logger: logger,
	}
}

func (a *fedCfgAdapter) GetConfigByDomainID(ctx context.Context, domainID uint64) (models.FederationConfig, error) {
	a.logCtx(ctx).Infof("GetConfigByDomainID(%+v)", domainID)
	response, err := a.client.GetConfigByDomainID(ctx, domainID)
	if err != nil {
		return models.FederationConfig{}, fmt.Errorf("error getting config: %w", err)
	}
	config := models.FederationConfig{
		OAuthClient: response.OAuthConfig.ClientID,
		ConfigID:    response.SamlConfig.ConfigID,
		EntityID:    response.SamlConfig.EntityID,
		DomainIDs:   response.SamlConfig.DomainIDs,
		Enabled:     response.Enabled,
	}
	return config, nil
}
