package inmemory

import (
	"fmt"
	"reflect"

	"github.com/elimity-com/scim"

	"a.yandex-team.ru/passport/backend/scim_api/internal/core/models"
)

var tagName = "patch"

func applySinglePatch(user *models.User, patch scim.PatchOperation) bool {
	v := reflect.ValueOf(user).Elem()
	t := reflect.TypeOf(*user)
	for i := 0; i < v.NumField(); i++ {
		field := t.Field(i)
		tagValue := field.Tag.Get(tagName)
		if tagValue == patch.Path.AttributePath.AttributeName {
			// FIXME надо поддержать работу еще с add / delete
			// FIXME и поддержать работу с комплексными типами (вложенные дикты / списки с диктами)
			if patch.Op == scim.PatchOperationReplace {
				f := v.FieldByName(field.Name)
				if !f.CanSet() {
					panic(fmt.Errorf("field setability is false"))
				}
				switch patch.Value.(type) {
				case string:
					f.SetString(patch.Value.(string))
					return true
				case bool:
					f.SetBool(patch.Value.(bool))
					return true
				default:
					panic(fmt.Errorf("type unknown"))
				}
			}
		}
	}
	return false
}
