package bbutils

import (
	"time"

	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm"
	passportBlackbox "a.yandex-team.ru/passport/shared/golibs/blackbox"
)

type BlackboxConfig struct {
	BlackboxURL     string `json:"url"`
	BlackboxTimeout string `json:"timeout"`
	TVMID           int    `json:"tvm_id"`
}

func MaskOAuthToken(token string) string {
	return token[:len(token)/2] + "***"
}

func NewBlackboxClient(cfg BlackboxConfig, tvmClient tvm.Client) passportBlackbox.Client {
	timeout, err := time.ParseDuration(cfg.BlackboxTimeout)
	if err != nil {
		panic(err)
	}
	bbClient, err := passportBlackbox.NewBlackBoxClient(
		httpbb.Environment{
			BlackboxHost: cfg.BlackboxURL,
			TvmID:        tvm.ClientID(cfg.TVMID),
		},
		httpbb.WithTimeout(timeout),
		httpbb.WithTVM(tvmClient),
	)

	if err != nil {
		panic(err)
	}

	return bbClient
}
