package users

import (
	"context"
	"fmt"

	"github.com/elimity-com/scim"

	"a.yandex-team.ru/passport/backend/scim_api/internal/core/interfaces"
	"a.yandex-team.ru/passport/backend/scim_api/internal/core/models"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type controller struct {
	scimAdapter interfaces.SCIMAdapter
}

// compile-time проверка, что интерфейс имплементирован корректно
var _ interfaces.UsersController = (*controller)(nil)

func NewController(scimAdapter interfaces.SCIMAdapter) *controller {
	return &controller{
		scimAdapter: scimAdapter,
	}
}

// FIXME унести это в общий логгер какой-то, потом станет ясно
func (ctrl *controller) logf(msg string, args ...interface{}) {
	logger.Log().Infof(fmt.Sprintf("[AuthController] %s", msg), args...)
}

func (ctrl *controller) log(msg string) {
	logger.Log().Infof(fmt.Sprintf("[AuthController] %s", msg))
}

func (ctrl *controller) RegisterUser(ctx context.Context, user models.User) (models.User, error) {
	return ctrl.scimAdapter.RegisterUser(ctx, user)
}

func (ctrl *controller) PatchUser(ctx context.Context, userID string, patches []scim.PatchOperation) (models.User, error) {
	return ctrl.scimAdapter.PatchUser(ctx, userID, patches)
}

func (ctrl *controller) GetUser(ctx context.Context, userID string) (models.User, error) {
	return ctrl.scimAdapter.GetUser(ctx, userID)
}

func (ctrl *controller) ReplaceUser(ctx context.Context, userID string, user models.User) (models.User, error) {
	return ctrl.scimAdapter.ReplaceUser(ctx, userID, user)
}

func (ctrl *controller) DeleteUser(ctx context.Context, userID string) error {
	return ctrl.scimAdapter.DeleteUser(ctx, userID)
}

func (ctrl *controller) ListUsers(ctx context.Context, startIndex uint64, limit uint64) (uint64, []models.User, error) {
	return ctrl.scimAdapter.ListUsers(ctx, startIndex, limit)
}
