package interfaces

import (
	"context"

	"github.com/elimity-com/scim"

	"a.yandex-team.ru/passport/backend/scim_api/internal/core/models"
)

type SCIMAdapter interface {
	RegisterUser(ctx context.Context, user models.User) (models.User, error)
	PatchUser(ctx context.Context, userID string, patches []scim.PatchOperation) (models.User, error)
	GetUser(ctx context.Context, userID string) (models.User, error)
	ReplaceUser(ctx context.Context, userID string, user models.User) (models.User, error)
	DeleteUser(ctx context.Context, userID string) error
	ListUsers(ctx context.Context, startIndex uint64, limit uint64) (uint64, []models.User, error)
}

type DomainsAdapter interface {
	DomainExists(ctx context.Context, domainID uint64) (bool, error)
}

type AuthAdapter interface {
	CheckCredentials(ctx context.Context, credentials models.Credentials) (models.ClientInfo, error)
}

type FederationConfigAdapter interface {
	GetConfigByDomainID(ctx context.Context, domainID uint64) (models.FederationConfig, error)
}
