package models

import "time"

type Email struct {
	Address   string `patch:"emails.value"`
	IsPrimary bool
}

type PhoneNumber struct {
	PhoneNumber string
}

type User struct {
	UserName       string `patch:"userName"`
	PassportUID    uint64
	FirstName      string `patch:"name.givenName"`
	LastName       string `patch:"name.familyName"`
	DisplayName    string `patch:"displayName"`
	Emails         []Email
	PhoneNumbers   []PhoneNumber
	DomainID       uint64
	IsActive       bool `patch:"active"`
	SCIMAttributes SCIMAttributes
}

type SCIMAttributes struct {
	CreatedTime  time.Time
	ModifiedTime time.Time
	ExternalID   string
}

type Credentials struct {
	Credential string
	UserIP     string
}

type ClientInfo struct {
	ClientID string
}
