package fedcfgclient

import (
	"net/http"
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

type fedCfgClient struct {
	Client    *http.Client
	TvmClient tvm.Client
	URL       string
	TVMID     tvm.ClientID
}

var _ APIClient = (*fedCfgClient)(nil)

func DefaultHTTPClient(timeout time.Duration) *http.Client {
	var httpClient = &http.Client{
		Timeout: timeout,
		// отключает следование по редиректам
		CheckRedirect: func(req *http.Request, via []*http.Request) error {
			return http.ErrUseLastResponse
		},
	}
	return httpClient
}

func NewFedCfgAPIClient(tvmClient tvm.Client, tvmID tvm.ClientID, url string, timeout time.Duration) (*fedCfgClient, error) {
	return &fedCfgClient{
		Client:    DefaultHTTPClient(timeout),
		TvmClient: tvmClient,
		TVMID:     tvmID,
		URL:       url,
	}, nil
}
