package fedcfgclient

import (
	"context"
	"encoding/json"
	"fmt"
)

type HostedDomainsRequest struct {
	DomainID uint64
}

func (c *fedCfgClient) GetConfigByDomainID(ctx context.Context, domainID uint64) (FedCfgConfigResponse, error) {
	var parsedResponse FedCfgConfigResponse

	params := map[string]string{
		"namespace": "360", // TODO: в будущем предусмотреть настройку неймспейса
	}
	statusCode, body, err := c.request(ctx, "GET", fmt.Sprintf("/1/config/by_domain_id/%d/", domainID), params)

	if err != nil {
		return parsedResponse, fmt.Errorf("fedcfg_api request failed: %w", err)
	}

	if statusCode != 200 && statusCode != 201 {
		return parsedResponse, fmt.Errorf("fedcfg_api responded with status=%d ('%s')", statusCode, body)
	}

	if err := json.Unmarshal(body, &parsedResponse); err != nil {
		return parsedResponse, fmt.Errorf("failed to parse fedcfg_api response: %w", err)
	}

	return parsedResponse, nil
}
