package fedcfgclient

import (
	"context"
	"io/ioutil"
	"net/http"
)

func (c *fedCfgClient) request(ctx context.Context, method string, path string, params map[string]string) (int, []byte, error) {
	var (
		statusCode int
		body       []byte
	)
	queryURL := c.URL + path

	request, err := http.NewRequestWithContext(ctx, method, queryURL, nil)
	if err != nil {
		return statusCode, body, err
	}

	tvmTicket, err := c.TvmClient.GetServiceTicketForID(ctx, c.TVMID)
	if err != nil {
		return statusCode, body, err
	}

	query := request.URL.Query()
	for k, v := range params {
		query.Add(k, v)
	}
	request.URL.RawQuery = query.Encode()

	request.Header.Add("X-Ya-Service-Ticket", tvmTicket)
	request.Header.Add("Content-Type", "application/x-www-form-urlencoded")

	response, err := c.Client.Do(request)
	if err != nil {
		return statusCode, body, err
	}
	if response != nil {
		defer response.Body.Close()
	}
	statusCode = response.StatusCode
	body, err = ioutil.ReadAll(response.Body)
	if err != nil {
		return statusCode, body, err
	}
	return statusCode, body, nil
}
