package logutils

import (
	"context"
	"errors"
	"strconv"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/shared/golibs/httpdaemon/middlewares"
)

type ctxRequestKey struct{}
type CtxRequest struct {
	ClientIP          string
	ExternalRequestID string
	DomainID          uint64
}

var crk ctxRequestKey

func GetClientIP(ctx context.Context) (string, error) {
	r := ctx.Value(&crk)
	if r != nil {
		request := r.(*CtxRequest)
		return request.ClientIP, nil
	}
	return "", errors.New("no request data in context. probably misconfigured middleware")
}

func GetDomainID(ctx context.Context) (uint64, error) {
	r := ctx.Value(&crk)
	if r != nil {
		request := r.(*CtxRequest)
		return request.DomainID, nil
	}
	return 0, errors.New("no request data in context. probably misconfigured middleware")
}

func AddRequestToContext(ctx context.Context, r *CtxRequest) context.Context {
	return context.WithValue(ctx, &crk, r)
}

func AddCommonFromContext(ctx context.Context, l log.Logger) log.Logger {
	var (
		reqID       string
		tvmClientID string
		fields      map[string]string
		request     *CtxRequest
	)

	reqID = middlewares.ContextReqID(ctx)
	if reqID == "" {
		reqID = "-"
	}

	st := tvm.ContextServiceTicket(ctx)
	if st != nil {
		tvmClientID = strconv.Itoa(int(st.SrcID))
	} else {
		tvmClientID = "-"
	}

	r := ctx.Value(&crk)
	if r != nil {
		request = r.(*CtxRequest)
		if request != nil {
			fields = map[string]string{
				"client_ip": request.ClientIP,
			}
			if request.ExternalRequestID != "" {
				fields["external_request_id"] = request.ExternalRequestID
			}
		} else {
			fields = map[string]string{}
		}
		fields["tvm_client_id"] = tvmClientID
	}

	return log.With(
		l,
		log.String("request_id", reqID),
		log.Any("@fields", fields),
	)
}
