package scimapi

import (
	"github.com/elimity-com/scim"
	"github.com/elimity-com/scim/optional"
	"github.com/elimity-com/scim/schema"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/passport/backend/scim_api/internal/core/interfaces"
)

func GetScimServer(usersController interfaces.UsersController, authController interfaces.AuthController, logger log.Logger) scim.Server {
	scimConfig := scim.ServiceProviderConfig{
		DocumentationURI: optional.NewString("www.example.com/scim"),
		SupportPatch:     true,
		SupportFiltering: true,
	}

	userSchema := schema.Schema{
		ID:          "urn:ietf:params:scim:schemas:core:2.0:User",
		Name:        optional.NewString("User"),
		Description: optional.NewString("User Account"),
		Attributes: []schema.CoreAttribute{
			schema.SimpleCoreAttribute(schema.SimpleStringParams(schema.StringParams{
				Name:       "userName",
				Required:   true,
				Uniqueness: schema.AttributeUniquenessServer(),
			})),
			schema.SimpleCoreAttribute(schema.SimpleBooleanParams(schema.BooleanParams{
				Name:     "active",
				Required: true,
			})),
			schema.SimpleCoreAttribute(schema.SimpleStringParams(schema.StringParams{
				Name:     "externalID",
				Required: true,
			})),
			schema.SimpleCoreAttribute(schema.SimpleStringParams(schema.StringParams{
				Name: "displayName",
			})),
			schema.ComplexCoreAttribute(schema.ComplexParams{
				MultiValued: true,
				Name:        "emails",
				SubAttributes: []schema.SimpleParams{
					schema.SimpleBooleanParams(schema.BooleanParams{
						Name: "Primary",
					}),
					schema.SimpleStringParams(schema.StringParams{
						Name: "type",
					}),
					schema.SimpleStringParams(schema.StringParams{
						Name: "value",
					}),
				},
				Required: false,
			}),
			schema.ComplexCoreAttribute(schema.ComplexParams{
				MultiValued: true,
				Name:        "phoneNumbers",
				SubAttributes: []schema.SimpleParams{
					schema.SimpleBooleanParams(schema.BooleanParams{
						Name: "Primary",
					}),
					schema.SimpleStringParams(schema.StringParams{
						Name: "type",
					}),
					schema.SimpleStringParams(schema.StringParams{
						Name: "value",
					}),
				},
				Required: false,
			}),
			schema.ComplexCoreAttribute(schema.ComplexParams{
				Name: "name",
				SubAttributes: []schema.SimpleParams{
					schema.SimpleStringParams(schema.StringParams{
						Name:     "formatted",
						Required: false,
					}),
					schema.SimpleStringParams(schema.StringParams{
						Name:     "familyName",
						Required: false,
					}),
					schema.SimpleStringParams(schema.StringParams{
						Name:     "givenName",
						Required: false,
					}),
				},
				Required: false,
			}),
		},
	}

	userResourceHandler := userResourceHandler{
		usersController: usersController,
		authController:  authController,
		logger:          logger,
	}

	resourceTypes := []scim.ResourceType{
		{
			ID:               optional.NewString("User"),
			Name:             "User",
			Endpoint:         "/Users",
			Description:      optional.NewString("User Account"),
			Schema:           userSchema,
			SchemaExtensions: []scim.SchemaExtension{},
			Handler:          userResourceHandler,
		},
	}

	server := scim.Server{
		Config:        scimConfig,
		ResourceTypes: resourceTypes,
	}
	return server
}
