# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.social.common.chrono import now


class StatboxLogEntry(TskvLogEntry):
    def __init__(self, **params):
        params.setdefault('tskv_format', 'social-api-log')
        params.setdefault('unixtime', now.i())
        super(StatboxLogEntry, self).__init__(**params)


class StatboxLogger(TskvLogger):
    default_logger_name = 'statbox'
    entry_class = StatboxLogEntry
