# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from flask import request
from passport.backend.social.api.common import (
    error,
    get_grants_config,
)
from passport.backend.social.common.grants import (
    Grants,
    GrantsContext,
)
from passport.backend.social.common.web_service import description_for_consumer_from_grants_missing_error


def get_grants_context():
    consumer_ip = request.headers.get('X-Real-Ip') or request.environ['REMOTE_ADDR']
    consumer = request.values.get('consumer')
    ticket_body = request.headers.get('X-Ya-Service-Ticket')
    return GrantsContext(
        consumer_ip=consumer_ip,
        consumer=consumer,
        ticket_body=ticket_body,
    )


def access_denied(reason):
    description = description_for_consumer_from_grants_missing_error(reason)
    return error(code=403, name='access-denied', description=description)


class _SocialApiGrants(Grants):
    def __init__(self):
        super(_SocialApiGrants, self).__init__(
            context_getter=get_grants_context,
            error_func=access_denied,
        )

    def check_any_of_grants(self, *args, **kwargs):
        get_grants_config().load()
        return super(_SocialApiGrants, self).check_any_of_grants(*args, **kwargs)

    def _check_grants_and_call_function(self, *args, **kwargs):
        get_grants_config().load()
        return super(_SocialApiGrants, self)._check_grants_and_call_function(*args, **kwargs)


build_grants_checking_decorator = _SocialApiGrants()
