# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.api.views.v3.base import InternalApiHandlerV3
from passport.backend.social.common import validators
from passport.backend.social.common.db.utils import (
    get_master_engine,
    get_slave_engine,
)
from passport.backend.social.common.profile import update_many_profiles
from passport.backend.social.common.token.db import TokenRecord


class _DeleteSocialDataForm(validators.Schema):
    profile_ids = validators.ProfileIdSet()


class DeleteSocialData(InternalApiHandlerV3):
    required_grants = ['delete-social-data']
    basic_form = _DeleteSocialDataForm()

    def _process_request(self):
        update_many_profiles(
            self.form_values['profile_ids'],
            dict(
                birthday=None,
                city='',
                country='',
                email='',
                firstname='',
                gender='',
                lastname='',
                nickname='',
                phone='',
                username='',
            ),
            get_master_engine(),
        )
        TokenRecord.delete_all_for_profile_ids(
            self.form_values['profile_ids'],
            get_slave_engine(),
            get_master_engine(),
        )
