PY2_LIBRARY()

NEED_REVIEW()
OWNER(g:passport_python)

PEERDIR(
    contrib/python/Flask
    contrib/python/Werkzeug
    contrib/python/sqlalchemy/sqlalchemy-1.2
    library/python/yenv

    passport/backend/social/common
    passport/backend/social/proxylib
)

NO_CHECK_IMPORTS(
    passport.backend.social.api.wsgi
)

PY_SRCS(
    __init__.py
    app.py
    common.py
    gunicorn_app.py
    logging_settings.py
    project.py
    statbox.py
    test.py
    views/__init__.py
    views/v2/__init__.py
    views/v2/base.py
    views/v2/grants.py
    views/v2/tasks.py
    views/v2/views.py
    views/v3/__init__.py
    views/v3/base.py
    views/v3/delete_social_data.py
    views/v3/station_application.py
    views/v3/unbind_phonish_by_uid.py
    views/v3/who_shares.py
    wsgi.py
)

END()


RECURSE(
    bin/dev_server
    bin/gunicorn
    dev
)


RECURSE_FOR_TESTS(
    tests
)
