# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.core.avatars import upload_avatar_async
from passport.backend.social.common.misc import (
    format_traceback,
    get_max_size_avatar,
)


logger = logging.getLogger(__name__)


def upload_user_avatar_async(task):
    """
    Попробуем отправить аватар пользователя в MDS.
    """
    try:
        social_userinfo = task.get_social_userinfo()
        avatars = social_userinfo.get('avatar', dict())
        avatar_url = get_max_size_avatar(avatars)
        if not avatar_url:
            return

        upload_avatar_async(
            uid=task.uid,
            avatar_url=avatar_url,
            skip_if_set=True,
        )
        logger.debug('Requested avatar upload for uid=%s' % task.uid)
    except Exception:
        logger.warning('Error while uploading user avatar: %s' % format_traceback())
