# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from functools import partial
import logging

from passport.backend.social.broker.avatars import upload_user_avatar_async
from passport.backend.social.broker.statbox import to_statbox
from passport.backend.social.common.builders.blackbox import Blackbox
from passport.backend.social.common.context import request_ctx
from passport.backend.social.common.db.utils import (
    get_master_engine,
    get_slave_engine,
)
from passport.backend.social.common.multiprocessing import execute_multiple_methods
from passport.backend.social.common.profile import create_profile
from passport.backend.social.common.task import Task
from passport.backend.social.common.useragent import get_http_pool_manager


logger = logging.getLogger(__name__)


def bind_social_userinfo(account, userinfo, binding_data, has_binding=True):
    task = Task.from_social_userinfo(userinfo, account.uid, binding_data)
    bind_social_userinfo_by_task(task, binding_data, has_binding)


def bind_social_userinfo_by_task(task, binding_data, has_binding=True):
    # TODO Передавать has_binding с уровня выше -- неправильно, т.к. с нынешним
    # интерфейсом невозможно знать, существует ли профиль. Нужно научиться получать
    # такую информацию из create_profile.
    execute_multiple_methods([
        partial(_bind_profile_db, has_binding, binding_data.sid, task),
        partial(upload_user_avatar_async, task),
    ])


def log_bind_profile(task_id, uid, profile_id, profile_created):
    logger.info('Saved profile_id: %s' % profile_id)
    to_statbox({
        'task_id': task_id,
        'request_id': request_ctx.request_id,
        'action': 'bound',
        'uid': uid,
        'profile_id': profile_id,
        'profile_created': profile_created,
    })


def _bind_profile_db(has_profile, sid, task):
    profile_id = create_profile(
        get_slave_engine(),
        get_master_engine(),
        task.uid,
        task.get_social_userinfo(),
        task.get_token(),
        task.finished,
        task.yandexuid,
        subscription_id=sid,
        refresh_token=task.get_refresh_token(),
        blackbox=Blackbox(get_http_pool_manager()),
    )
    task.profile_id = profile_id
    log_bind_profile(task.task_id, task.uid, profile_id, not has_profile)


class BindingData(object):
    def __init__(self, sid=None, token=None, consumer=None, yandexuid=None,
                 refresh_token=None):
        self.sid = sid
        self.token = token
        self.refresh_token = refresh_token
        self.consumer = consumer
        self.yandexuid = yandexuid
