# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import OAuth2Communicator
from passport.backend.social.common import oauth2


logger = logging.getLogger(__name__)


def _detect_error_in_access_token_response(response):
    if 'access_token' not in response:
        error_code = response.get('id')
        if error_code == 'invalid_or_expired_code':
            raise oauth2.token.InvalidGrant()
        else:
            # Чтобы выяснить какие коды отказа возвращает Amediateka, будем
            # логировать все неизвестные.
            logger.error('Failed to exchange authorization code to token: %s' % error_code)
            raise oauth2.token.InvalidGrant()


class AmediatekaCommunicator(OAuth2Communicator):
    provider_code = 'amediateka'

    OAUTH_AUTHORIZE_URL = 'https://www.amediateka.ru/external.html?action=login'

    OAUTH_ACCESS_TOKEN_URL = 'https://api.amediateka.ru/external/v1/users/oauth_authorize_token.json'
    ACCESS_TOKEN_REQUEST_TYPE = 'POST'

    def _get_error_detector_for_access_token_response(self):
        return _detect_error_in_access_token_response
