# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.broker.communicators.communicator import OAuth2CommunicatorWithAbsoluteRedirect
from passport.backend.social.broker.exceptions import ApplicationUnknownError
from passport.backend.social.common.providers.Apple import Apple
from passport.backend.social.proxylib import get_proxy
from passport.backend.utils.common import noneless_dict


class AppleCommunicator(OAuth2CommunicatorWithAbsoluteRedirect):
    provider_code = Apple.code

    def check_token(self, token):
        return self._check_token(token)

    def get_real_token_data(self, token, fail_silent=False, need_client_id=True):
        return self._get_real_token_data(token, fail_silent, need_client_id)

    def get_authorize_url(self, *args, **kwargs):
        # Чтобы предотвратить попытки авторизации в Вебе, бросаем отказ, чтобы
        # клиент посчитал, что такого провайдера вообще не существует.
        raise ApplicationUnknownError()

    def client_token_to_social_userinfo(self, client_token):
        proxy = get_proxy(code=self.provider_code, app=self.app)
        userinfo = proxy.client_token_to_profile(client_token)
        return noneless_dict(userinfo)
