# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.broker.communicators.communicator import OAuth2Communicator
from passport.backend.social.broker.exceptions import (
    CommunicationFailedError,
    UserDeniedError,
)
from passport.backend.social.common.providers.Deezer import Deezer


class DeezerCommunicator(OAuth2Communicator):
    provider_code = Deezer.code
    OAUTH_AUTHORIZE_URL = 'https://connect.deezer.com/oauth/auth.php?'
    default_scopes = [
        'basic_access',
        'offline_access',
    ]
    OAUTH_ACCESS_TOKEN_URL = 'https://connect.deezer.com/oauth/access_token.php?'
    ACCESS_TOKEN_RESPONSE_FORMAT = 'urlencoded'
    REDIRECT_NEEDED = True

    def has_error_in_callback(self, query, *args, **kwargs):
        error_name = query.get('error_reason')
        if error_name:
            if error_name == 'user_denied':
                raise UserDeniedError('User denied access')
            raise CommunicationFailedError('Error in callback: %s' % error_name)
