# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import OAuth2CommunicatorWithAbsoluteRedirect
from passport.backend.social.broker.exceptions import (
    CommunicationFailedError,
    UserDeniedError,
)


logger = logging.getLogger('social.broker.communicators')


class GoogleCommunicator(OAuth2CommunicatorWithAbsoluteRedirect):
    OAUTH_ACCESS_TOKEN_URL = 'https://accounts.google.com/o/oauth2/token'
    OAUTH_AUTHORIZE_URL = 'https://accounts.google.com/o/oauth2/auth'
    ACCESS_TOKEN_REQUEST_TYPE = 'POST'
    REDIRECT_NEEDED = True
    OAUTH_AUTHORIZE_MANDATORY_ARGUMENTS = {'access_type': 'offline'}

    default_scopes = [
        'https://www.googleapis.com/auth/userinfo.profile',
        'https://www.googleapis.com/auth/userinfo.email',
    ]
    scope_delimiter = ' '
    provider_code = 'gg'

    _force_prompt_args = {'prompt': 'consent'}

    def has_error_in_callback(self, query, *args, **kwargs):
        error_name = query.get('error')
        if error_name:
            if error_name == 'access_denied':
                raise UserDeniedError('User denied access')
            raise CommunicationFailedError('Error in callback: ' + str(query['error']))

    def get_real_token_data(self, token, fail_silent=False, need_client_id=True):
        return self._get_real_token_data(token, fail_silent=fail_silent, need_client_id=need_client_id)

    def check_token(self, token):
        return self._check_token(token)
