# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import (
    OAuth2Communicator,
    OAuth2CommunicatorWithAbsoluteRedirect,
)
from passport.backend.social.broker.exceptions import (
    CommunicationFailedError,
    UserDeniedError,
)
from passport.backend.social.common.providers.MailRu import MailRu


logger = logging.getLogger('social.broker.communicators')


def add_to_manager(manager):
    custom_mapping = {'o2': MailRuO2Communicator}
    manager.add_mapping(MailRu.code, MailRuCommunicator, mapping=custom_mapping)


class MailRuCommunicator(OAuth2Communicator):
    OAUTH_ACCESS_TOKEN_URL = 'https://connect.mail.ru/oauth/token'
    OAUTH_AUTHORIZE_URL = 'https://connect.mail.ru/oauth/authorize?'
    provider_code = MailRu.code
    REDIRECT_NEEDED = True

    ACCESS_TOKEN_REQUEST_TYPE = 'POST'

    scope_delimiter = ' '

    display_map = {
        'page': 'popup',
        'popup': 'popup',
        'touch': 'mobile',
        'wap': 'mobile',
    }

    def has_error_in_callback(self, query, *args, **kwargs):
        error_name = query.get('error')
        if error_name:
            if error_name == 'access_denied':
                raise UserDeniedError('User denied access')
            raise CommunicationFailedError('Error in callback: ' + str(query['error']))


class MailRuO2Communicator(OAuth2CommunicatorWithAbsoluteRedirect):
    OAUTH_AUTHORIZE_URL = 'https://o2.mail.ru/login?'
    OAUTH_ACCESS_TOKEN_URL = 'https://o2.mail.ru/token?'
    provider_code = MailRu.code

    ACCESS_TOKEN_REQUEST_TYPE = 'POST'

    default_scopes = ['userinfo', 'mail.imap']
    scope_delimiter = ' '

    def _build_login_hint_args(self, login_hint):
        assert login_hint
        return {'login': login_hint}
