# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
import logging

from passport.backend.social.broker.communicators.communicator import OAuth2CommunicatorWithAbsoluteRedirect
from passport.backend.social.broker.exceptions import UserDeniedError
from passport.backend.social.common.misc import expires_in_to_expires_at
from passport.backend.social.common.providers.Meethue import (
    Meethue,
    meethue_authorization_header,
)


logger = logging.getLogger(__name__)


class MeethueCommunicator(OAuth2CommunicatorWithAbsoluteRedirect):
    provider_code = Meethue.code

    OAUTH_AUTHORIZE_URL = 'https://api.meethue.com/oauth2/auth?appid=yandex&deviceid=yandex'
    REDIRECT_NEEDED = True

    OAUTH_ACCESS_TOKEN_URL = 'https://api.meethue.com/oauth2/token'
    ACCESS_TOKEN_REQUEST_TYPE = 'POST'

    def has_error_in_callback(self, query, *args, **kwargs):
        if not query.get('code'):
            raise UserDeniedError('User denied access')

    def get_access_token_request(
        self,
        callback_url=None,
        client_id=None,
        client_secret=None,
        code=None,
        scopes=None,
    ):
        client_id = client_id or self.app.id
        client_secret = client_secret or self.app.secret

        full_url, data, headers = super(MeethueCommunicator, self).get_access_token_request(
            callback_url=callback_url,
            client_id=client_id,
            client_secret=client_secret,
            code=code,
            scopes=scopes,
        )
        data = dict(data)
        del data['client_id']
        del data['client_secret']

        headers = dict(headers)
        headers['Authorization'] = meethue_authorization_header(client_id, client_secret)
        return full_url, data, headers

    def parse_access_token(self, response):
        token = super(MeethueCommunicator, self).parse_access_token(response)
        response = json.loads(response)
        expires = response.get('access_token_expires_in')
        if expires is not None:
            token['expires'] = expires_in_to_expires_at(expires)
        return token
